import org.serviio.library.online.*
import org.serviio.library.metadata.*
import java.util.regex.*

/**
 * www.radiobremen.de content URL extractor plugin for Serviio. 
 * 
 * @author Olaf Ahrens (thanks to htb)
 * @version 1.0
 */
public class RadioBremen extends FeedItemUrlExtractor {

	//part VIDEO:
	//example image:	http://httpmedia.radiobremen.de/mediabase/066611/066611_01786093_01786097.jpg
	//examples video:
	//	.mp4 big		rtmpt://flashmedia.radiobremen.de/a792/e6/mediabase/066611/066611_231121_512.mp4
	//	.mp4 small		rtmpt://flashmedia.radiobremen.de/a792/e6/mediabase/066611/066611_231120_256.mp4
	//	.wmv big		http://windowsmedia.radiobremen.de/a792/e3/mediabase/066611/066611_231119_512.wmv
	//	.wmv small		http://windowsmedia.radiobremen.de/a792/e3/mediabase/066611/066611_231117_256.wmv
	//	coding:			linkID + '/' + folderID + '/mediabase/' + metaID + '/' + metaID + '_' + fileID + '_' + widthID + extensionID

	//part AUDIO:
	//example image:
	//examples audio:
	//	.flv			rtmpt://flashmedia.radiobremen.de/a792/e6/mediabase/067197/067197_233187_audio-s.flv
	//	.wma			http://windowsmedia.radiobremen.de/a792/e3/mediabase/067197/067197_233188.wma
	//	coding:			linkID + '/' + folderID + '/mediabase/' + metaID + '/' + metaID + '_' + fileID + '_' + widthID + extensionID

	private static final VALID_FEED_URL  = '(?i)http://www.radiobremen.de/feed/rss/.*'
	private static final VALID_THUMB_URL = '(?i)http://httpmedia.radiobremen.de/mediabase.*'
	private static final VALID_PLAYERBEREICH = '(?i).*ardformatplayerclassic.*'
	private static final VALID_RADIOLINK = '(?i).*audio.*-popup.html.*'
	private static final USER_AGENT = 'Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/14.0.835.186 Safari/535.1'

	@Override
	public String getExtractorName() {
		return 'Radio Bremen RSS Extractor'
	}

	public boolean extractorMatches(URL feedUrl) {
		return feedUrl ==~ VALID_FEED_URL
	}


	protected ContentURLContainer extractUrl(Map links, PreferredQuality quality) {

		//* * * declarations
		String mediaUrl
		MediaFileType mediaType
		String thumbnailUrl
		Boolean passed = false
		Matcher myMatcher
		String[] myTokens

		//* * * extract Url
		URL webpage1Url = links['alternate'] == null? links['default'] : links['alternate'] 
		log('  - webpage1Url: ' + webpage1Url.toString())
		String webpage1Content = webpage1Url.getText()

		//* * * VIDEO
		myMatcher = (webpage1Content =~ VALID_THUMB_URL)
		if ((myMatcher != null) && (myMatcher.size() != 0)) {
			log('  - type medium: video')

			//* * * extract image for video
			thumbnailUrl =  myMatcher[0].toString().split('"')[0]
			log('  - thumbnailUrl: ' + thumbnailUrl)

			//* * * extract video
			myMatcher = webpage1Content =~ VALID_PLAYERBEREICH
			if ((myMatcher != null) && (myMatcher.size() > 0)) {

				myTokens = myMatcher[0].toString().split('\',\'')
				String metaID = myTokens[3]
				String fileID = myTokens[4]

				String linkID = 'rtmpt://flashmedia.radiobremen.de'
				String folderID = 'a792/e6'
				String extensionID = '.mp4'
				String widthID = '512'

				mediaUrl = linkID + '/' + folderID + '/mediabase/' + metaID + '/' + metaID + '_' + fileID + '_' + widthID + extensionID
				log('  - mediaUrl: ' + mediaUrl)
				mediaType = MediaFileType.VIDEO
				passed = true
			}
		}

		//* * * AUDIO
		if (!passed) {
			myMatcher = webpage1Content =~ VALID_RADIOLINK
			if ((myMatcher != null) && (myMatcher.size() > 0)) {
				log('  - type medium: audio')

							//* * * extract Url
				URL webpage2Url = new URL('http://www.radiobremen.de' + myMatcher[0].toString().split('"')[1])
				log('  - webpage2Url: ' + webpage2Url.toString())
				String webpage2Content = openURL(webpage2Url, USER_AGENT)

				//* * * extract image for audio
				myTokens = webpage2Content.split('ardformatplayer\\(')[1].split('\'')
				thumbnailUrl = 'http://www.radiobremen.de' + myTokens[3]
				log('  - thumbnailUrl: ' + thumbnailUrl)

				//* * * extract audio
				String metaID = myTokens[1]
				String fileID = webpage2Content.split('\\[\'3\\.6\']')[1].split('\'')[1]

				String linkID = 'rtmpt://flashmedia.radiobremen.de'
				String folderID = 'a792/e6'
				String extensionID = '.flv'
				String widthID = 'audio-s'

				mediaUrl = linkID + '/' + folderID + '/mediabase/' + metaID + '/' + metaID + '_' + fileID + '_' + widthID + extensionID
				log('  - mediaUrl: ' + mediaUrl)
				mediaType = MediaFileType.AUDIO
				passed = true
			}
		}

		//return
		if (passed) {
			log('--- content URL cached')
			return new ContentURLContainer(fileType: mediaType, contentUrl: mediaUrl, thumbnailUrl: thumbnailUrl, live: false)
		} else {
			log('--- content URL not found')
			return null
		}
	}


	/**
	 * for testing
	 */
	protected static void main(String[] args) {
		String testUrl = 'http://www.radiobremen.de/feed/rss/neuestebeitraege100.xml';

		RadioBremen rb = new RadioBremen();
		assert rb.extractorMatches(new URL(testUrl))

		Map links = ['alternate': new URL('http://www.radiobremen.de/mediathek/index.html?id=066611')]
		ContentURLContainer result = rb.extractUrl(links, PreferredQuality.MEDIUM)
	}
}
